/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* ***********************************************************************
   *                                                                     *
   * decode.h                                                            *
   * Christian Zurhorst, BID R&D, 13. Nov. 1997                          *
   *                                                                     *
   * functions to control configuration space and target decoders        *
   *                                                                     *
   ***********************************************************************

*/

#ifndef DECODE_H_INCLUDED
#define DECODE_H_INCLUDED

#include <tdecdefs.h>


#ifdef __cplusplus
extern "C" {
#endif
  


/* -----------------------------------------------------------------
 * Configuration Space Programming Functions 
 * ----------------------------------------------------------------- */

CLI b_errtype EXPORT  BestConfRegSet(           /* @conrset */
  b_handletype handle,
  b_int32      offset,          		/* @offs */
  b_int32      value            		/* @val */
  );


CLI b_errtype EXPORT  BestConfRegGet(           /* @conrget */
  b_handletype handle,
  b_int32      offset,          		/* @offs */
  b_int32      *value           		/* #RETURN "value =: %08lx\\h\n" */
  );


CLI b_errtype EXPORT  BestConfRegMaskSet(       /* @conrmaskset */
  b_handletype handle,
  b_int32      offset,          		/* @offs */
  b_int32      value            		/* @val */
  );


CLI b_errtype EXPORT  BestConfRegMaskGet(       /* @conrmaskget */
  b_handletype handle,
  b_int32      offset,          		/* @offs */
  b_int32      *value           		/* #RETURN "value =: %08lx\\h\n" */
  );
  
CLI b_errtype EXPORT BestConfRegModify(		/* @conrmodify */
  b_handletype handle,
  b_int32 offset,				/* @offs */
  b_int32 value,				/* @val */
  b_int32 mask					/* @mask */
  );


/* ------------------------------------------------------------------------
 * PCI Target Programming Functions
 * ------------------------------------------------------------------------ */

CLI  b_errtype EXPORT BestTargetDecoderPropDefaultSet(	/* @tdprpdefset */
  b_handletype  handle,
  b_decodertype	decoder_num   			/* @dec */
  );

CLI  b_errtype EXPORT BestTargetDecoderPropSet(	/* @tdprpset */
  b_handletype  handle,
  b_decproptype decoder_prop, 			/* @prop */
  b_int32       value         			/* @val  */
  );


/* convenience function, programs one decoder */
CLI  b_errtype EXPORT BestTargetDecoder1xProg(  /* @td1xprog */
  b_handletype handle,
  b_decodertype decoder_num,	     	       	/* @dec   */
  b_int32 mode,                   		/* @mode  */
  b_int32 size,		     			/* @size  */
  b_int32 base,		     			/* @base  */
  b_int32 speed,                  		/* @speed */
  b_int32 location,               		/* @loc   */
  b_int32 prefetch                		/* @prefetch */
  );


CLI  b_errtype EXPORT BestTargetDecoderPropGet( /* @tdprpget */
  b_handletype  handle,
  b_decproptype decoder_prop,  			/* @prop */
  b_int32       *value       			/* #RETURN "property value: %08lx\\h\n" */
  );



CLI b_errtype EXPORT BestTargetDecoderProg(  	/* @tdprog */
  b_handletype	handle,
  b_decodertype	decoder_num   			/* @dec */
  );


CLI b_errtype EXPORT BestTargetDecoderRead(  	/* @tdread */
  b_handletype	handle,
  b_decodertype	decoder_num   			/* @dec */
  );

CLI b_errtype EXPORT BestTargetDecoderPowerUpProg(  	/* @tdpuprog */
  b_handletype	handle,
  b_decodertype	decoder_num   			/* @dec */
  );


CLI b_errtype EXPORT BestTargetDecoderPowerUpRead(  	/* @tdpuread */
  b_handletype	handle,
  b_decodertype	decoder_num   			/* @dec */
  );


CLI b_errtype EXPORT BestPCIConfigCheck (		/* @cfgcheck */
  b_handletype	handle
  );


#ifdef __cplusplus
}
#endif

#endif




